var saveIndex = 0;
var winInfoList = new Object();

function saveWinInfo(info) {
   index = saveIndex++;
   winInfoList[index] = info;
   return index;
}

function getWinInfo(index) {
   if (index in winInfoList)
      return winInfoList[index];
   else
      return null;
}

function removeWinInfo(index) {
   if (index in winInfoList)
      delete winInfoList[index];
}

function markWindowCloseHandled(taskwinname) {
   for (var index in winInfoList) {
      if (winInfoList[index].checkingWindowName == taskwinname) {
         winInfoList[index].closeIsHandled = true;
      }
   }
}

function processTaskWindowUnload(taskwin) {
//window.alert("in processTaskWindowUnload()");
   // We copy some window properties to the info object now because IE won't
   // let us fetch them later.  Apparently, the only valid use of the Window
   // object after onunload returns in IE is to read the Window.closed property.
   info = new Object();
   info.checkingWindow = taskwin;
   info.checkingWindowName = taskwin.name;
   info.checkingWindowCount = 1000;       // Check every 10ms for 1 second
   info.taskId = taskwin.hmcTaskId;
   info.closeIsHandled = false;

   // We can't just pass the info object as an argument to the
   // checkForWindowClosed() function, so we must resort to this indirect
   // scheme, since we can pass a simple index.
   index = saveWinInfo(info);
   info.timeoutObj = window.setTimeout("checkForWindowClosed("+index+")", 10);
}

function checkForWindowClosed(index) {
//window.alert("in checkForWindowClosed");
   info = getWinInfo(index);
   if (info == null) {
//    window.alert("Got an interval event for an unknown task window index");
      // We don't renew the timeout, so we shouldn't get more events.
      return;
   }

   info.checkingWindowCount -= 10;

   if (info.checkingWindow.closed == true) {
      if (!info.closeIsHandled) {
         info.closeIsHandled = true;
         markWindowCloseHandled(info.checkingWindowName);

//       window.alert("Window shows closed after "+
//                    (1000-info.checkingWindowCount)+" milliseconds.  info.checkingWindow.closed == "+info.checkingWindow.closed);
         processWindowClosed(info.taskId);

      } else {
//       window.alert("Window close already handled.");
      }
      removeWinInfo(index);
      return;
   }

   if (info.checkingWindowCount <= 0) {
//    window.alert("Window doesn't show closed.");
      removeWinInfo(index);

   } else {
      info.timeoutObj = window.setTimeout("checkForWindowClosed("+index+")", 10);
   }
}

function processWindowClosed(taskId) {
   tempwin = window.open("/hmc/task?op=windowclose&taskId="+taskId, "", "width=1,height=1,top="+screen.availHeight+",left="+screen.availWidth);
   tempwin.blur();
}

function processMainWindowUnloaded(logoffAnnounceMsg) {
   // This method is used for both onunload and onbeforeunload.  We don't
   // actually want it to be called twice, but it's hard to know in advance
   // if a browser supports onbeforeunload, so we assign them both.  If we're
   // running as a beforeunload handler, therefore, we'll delete the onunload
   // property to prevent us from running again.  We do this in all
   // cases, actually, since it doesn't hurt.
   try {
      delete window.onunload;
   } catch (e) {
      // Ignore exception.
   }

   // A Logoff/Disconnect operation will close our window programmatically.
   // That operation first sets the hmcWindowIsClosed variable, so we use that
   // flag to know that this window close is intentional and that we should not
   // pop open a new window to prompt the user to logoff.
   if ("hmcWindowIsClosed" in window) {
      return;
   }

   window.hmcWindowIsClosed = "Y";

   windowName = (new Date()).getTime();
   tempwin = window.open("", "mainlogoff_"+windowName, "width=500,height=500,top="+((screen.availHeight-500)/2)+",left="+((screen.availWidth-500)/2));

   doc = tempwin.document;
   doc.writeln('<html><head>');
   doc.writeln('<script type="text/javascript">');
   doc.writeln('  function checkForMainWindowClose() {');
   doc.writeln('    if (window.opener==null || window.opener.closed) {')
   doc.writeln('      window.location.replace("/hmc/task?op=mainwindowclose&windowname=mainlogoff_'+windowName+'");');
   doc.writeln('    } else {');
   doc.writeln('      window.close();');
   doc.writeln('    }');
   doc.writeln('  }');
   doc.writeln('  window.setTimeout("checkForMainWindowClose()", 10);');
   doc.writeln('</script>');
   doc.writeln('</head><body>');
   doc.writeln(logoffAnnounceMsg);
   doc.writeln('</body></html>');
   doc.close();
   tempwin.focus();
}
